<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <title>AQO Holdings</title>
    <meta content="Responsive admin theme build on top of Bootstrap 4" name="description"/>
    <meta content="Themesdesign" name="author"/>
    <link rel="shortcut icon" href="admin_assets/images/favicon.ico">

    <link href="../plugins/bootstrap-datepicker/css/bootstrap-datepicker.min.css" rel="stylesheet">
    <!-- ckeditor -->

    <link href="admin_assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <link href="admin_assets/css/metismenu.min.css" rel="stylesheet" type="text/css">
    <link href="admin_assets/css/icons.css" rel="stylesheet" type="text/css">
    <link href="admin_assets/css/style.css" rel="stylesheet" type="text/css">

</head>

<body>

<!-- Begin page -->
<div id="wrapper">

    <!-- Top Bar Start -->
    <div class="topbar">

        <!-- LOGO -->
        <div class="topbar-left">
            <a href="{{route('home')}}" class="logo">
                AQO Holdings
            </a>
        </div>

        <!-- Search input -->
        <div class="search-wrap" id="search-wrap">
            <div class="search-bar">
                <input class="search-input" type="search" placeholder="Search"/>
                <a href="#" class="close-search toggle-search" data-target="#search-wrap">
                    <i class="mdi mdi-close-circle"></i>
                </a>
            </div>
        </div>

        <nav class="navbar-custom">
            <ul class="navbar-right list-inline float-right mb-0">


                <!-- full screen -->
                <li class="dropdown notification-list list-inline-item d-none d-md-inline-block">
                    <a class="nav-link waves-effect" href="#" id="btn-fullscreen">
                        <i class="fas fa-expand noti-icon "></i>
                    </a>
                </li>

                <!-- notification -->


                <li class="dropdown notification-list list-inline-item">
                    <div class="dropdown notification-list nav-pro-img">
                        <a class="dropdown-toggle nav-link arrow-none waves-effect nav-user" data-toggle="dropdown"
                           href="#" role="button" aria-haspopup="false" aria-expanded="false">
                            <i id="usericon" class="mdi mdi-account-circle"></i>
                        </a>
                        <div class="dropdown-menu dropdown-menu-right dropdown-menu-animated profile-dropdown">
                            <!-- item-->
                            <a class="dropdown-item text-danger" href="{{ route('logout') }}" onclick="event.preventDefault();
                                                     document.getElementById('logout-form').submit();"

                            ><i class="mdi mdi-power text-danger"></i> Logout</a>
                        </div>
                    </div>
                </li>
                <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                    @csrf
                </form>
                </li>

            </ul>

            <ul class="list-inline menu-left mb-0">
                <li class="float-left">
                    <button class="button-menu-mobile open-left waves-effect">
                        <i class="mdi mdi-menu"></i>
                    </button>
                </li>
            </ul>

        </nav>

    </div>
    <!-- Top Bar End -->

    <!-- ========== Left Sidebar Start ========== -->
    <div class="left side-menu">
        <div class="slimscroll-menu" id="remove-scroll">

            <!--- Sidemenu -->
            <div id="sidebar-menu">
                <!-- Left Menu Start -->
                <ul class="metismenu" id="side-menu">
                    <li class="menu-title">Menu</li>





                    <li class="">
                        <a href="javascript:void(0);" class="waves-effect" aria-expanded="false"><i class="dripicons-to-do"></i><span> News <span class="float-right menu-arrow"><i class="mdi mdi-chevron-right"></i></span> </span></a>
                        <ul class="submenu mm-collapse" style="height: 0px;">
                            <li><a href="/admin">News Upload</a></li>
                            <li><a href="/admintable">News Management</a></li>

                        </ul>
                    </li>

                </ul>

            </div>
            <!-- Sidebar -->
            <div class="clearfix"></div>

        </div>
        <!-- Sidebar -left -->

    </div>
    <!-- Left Sidebar End -->

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Update News</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="javascript:void(0);">Home</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="javascript:void(0);">News</a>
                                    </li>
                                    <li class="breadcrumb-item active">Update News</li>
                                </ol>
                            </div>
                        </div>


                    </div>
                </div>
                <!-- end page-title -->

                <div class="row">


                    <div class="col-lg-8">
                        <div class="card">
                            <div class="card-body">

                                <h4 class="mt-0 header-title">A.Q.O NEWS</h4>
                                <p class="sub-title"> Functions </p>

                                <form method="POST" action="{{route('update',$post->id)}}"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="form-group">
                                        <label>Title</label>
                                        <div>
                                            <input type="text" name="titel" class="form-control" required maxlength="50"
                                                   placeholder="Max 50 chars." value="{{ $post->titel }}"/>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Short Description</label>
                                        <div>
                                            <input type="text" name="shdescription" class="form-control" required
                                                   minlength="15" maxlength="60" placeholder="Min 15 chars."
                                                   value="{{ $post->shdescription }}"/>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="text">Description</label>
                                        <div>
                                            <textarea name="description" id="elm1"
                                                      name="area">{!! $post->description !!}</textarea>

                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="text">Previous image</label>
                                        <div>
                                            <img id="previous" src="{{asset('thumbnails/'.$post->thumbnail)}}"
                                                 width="50%" height="" alt=" ">

                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label>Image</label>
                                        <div class="form-input">
                                            <div class="preview">
                                                <img id="file-ip-1-preview">
                                            </div>
                                            <label for="file-ip-1">Upload Image</label>
                                            <input type="file" id="file-ip-1" accept="image/*" name="thumbnail"
                                                   onchange="showPreview(event);">

                                        </div>
                                    </div>
                            </div>

                            <div>
                                <button type="submit" class="btn btn-primary waves-effect waves-light">
                                    Submit
                                </button>
                                <a href="/admin" class="btn btn-secondary waves-effect m-l-5">
                                    Cancel
                                </a>
                            </div>
                        </div>
                        </form>

                    </div>
                </div>
            </div>
            <!-- end col -->
        </div>
        <!-- end row -->

    </div>
    <!-- container-fluid -->

</div>
<!-- content -->

<footer class="footer">
    © 2022 AQO Holdings <span class="d-none d-sm-inline-block"> - Developed by CodeXCore Technologies</span>.
</footer>

</div>
<!-- ============================================================== -->
<!-- End Right content here -->
<!-- ============================================================== -->

</div>
<!-- END wrapper -->


<!-- jQuery  -->
<script src="admin_assets/js/jquery.min.js"></script>
<script src="admin_assets/js/bootstrap.bundle.min.js"></script>
<script src="admin_assets/js/metismenu.min.js"></script>
<script src="admin_assets/js/jquery.slimscroll.js"></script>
<script src="admin_assets/js/waves.min.js"></script>

<script src="plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js"></script>

<!-- Parsley js -->
<script src="plugins/parsleyjs/parsley.min.js"></script>

<script src="admin_assets/plugins/tinymce/tinymce.min.js"></script>

<!-- App js -->
<script src="admin_assets/admin_assets/js/app.js"></script>
<script>
    $(document).ready(function () {
        if ($("#elm1").length > 0) {
            tinymce.init({
                selector: "textarea#elm1",
                theme: "modern",
                height: 300,
                plugins: [
                    "advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker",
                    "searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking",
                    "save table contextmenu directionality emoticons template paste textcolor"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | l      ink image | print preview media fullpage | forecolor backcolor emoticons",
                style_formats: [{
                    title: 'Bold text',
                    inline: 'b'
                }, {
                    title: 'Red text',
                    inline: 'span',
                    styles: {
                        color: '#ff0000'
                    }
                }, {
                    title: 'Red header',
                    block: 'h1',
                    styles: {
                        color: '#ff0000'
                    }
                }, {
                    title: 'Example 1',
                    inline: 'span',
                    classes: 'example1'
                }, {
                    title: 'Example 2',
                    inline: 'span',
                    classes: 'example2'
                }, {
                    title: 'Table styles'
                }, {
                    title: 'Table row 1',
                    selector: 'tr',
                    classes: 'tablerow1'
                }]
            });
        }
    });
</script>

<script type="text/javascript">
    function showPreview(event) {
        if (event.target.files.length > 0) {
            var src = URL.createObjectURL(event.target.files[0]);
            var preview = document.getElementById("file-ip-1-preview");
            preview.src = src;
            preview.style.display = "block";
        }
    }
</script>
<!-- App js -->
<script src="admin_assets/js/app.js"></script>

</body>

</html>
