<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\WellcomeController;
use League\CommonMark\Normalizer\SlugNormalizer;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/', [WellcomeController::class, 'homepage'])->name('homepage');
Route::get('/about-us', [WellcomeController::class, 'about']);
Route::get('/contact-us', [WellcomeController::class, 'contact']);
Route::get('/news', [WellcomeController::class, 'news'])->name('news');
Route::get('/manufacturing', [WellcomeController::class, 'manufacturing']);
Route::get('/sports-entertainment', [WellcomeController::class, 'entertainment']);
Route::get('/realestate', [WellcomeController::class, 'realestate']);
Route::get('/services', [WellcomeController::class, 'services']);
Route::get('/show{slug}', [WellcomeController::class, 'show'])->name('show');
Route::get('/brand', [WellcomeController::class, 'brand']);
Route::get('/careers', [WellcomeController::class, 'careers']);


Route::get('/search', [WellcomeController::class, 'search'])->name('search');


Route::get('/privacy-policy', [WellcomeController::class, 'privacyPolicy']);
Route::get('/cookie-policy', [WellcomeController::class, 'cookiePolicy']);
Route::post('contact-form', [WellcomeController::class, 'sendEmail']);


Auth::routes();
Route::middleware(['auth'])->group(function(){
Route::get('/admin', [HomeController::class, 'admin'])->name('home');
Route::get('/admintable', [HomeController::class, 'view'])->name('view');
Route::post('/newpost', [HomeController::class, 'newpost']);
Route::get('/delete{postId}', [HomeController::class, 'delete'])->name('delete');
Route::post('/update{postId}', [HomeController::class, 'update'])->name('update');
Route::get('/edit{postId}', [HomeController::class, 'edit'])->name('edit');
});
