<?php

namespace App\Http\Controllers;

use App\Models\SearchModel;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use App\Mail\ContactMail;
use App\Models\Post;
use Illuminate\Support\Facades\Mail;

class WellcomeController extends Controller
{
    public function  homepage()
    {  $post= DB::table('posts')->latest()->take(2)->get();
        $news= DB::table('posts')->latest()->skip(2)->take(3)->get();
        return view('homepage',compact('post','news'));
    }
    public function  about()
    {
        return view('aboutus');
    }
    public function  contact()
    {
        return view('contactus');
    }
    public function  news()
    {     //$posts =Post:: orderBy('created_at', 'DESC')->paginate(3);
        $post= DB::table('posts')->latest()->get();

        return view('news', compact('post'));
    }
    public function  show( $slug)
    {
        $post= DB::table('posts')->where("slug",$slug)->first();

        return view('news1',compact('post'));
    }
    public function  manufacturing()
    {
        return view('manufacturing');
    }
    public function  entertainment()
    {
        return view('entertainment');
    }
    public function  realestate()
    {
        return view('realestate');
    }
    public function  services()
    {
        return view('services');
    }
    public function  privacyPolicy()
    {
        return view('privacyPolicy');
    }
    public function  cookiePolicy()
    {
        return view('cookiePolicy');
    }
    public function  brand()
    {
        return view('brand');
    }
    public function  careers()
    {
        return view('careers');
    }
    public function sendEmail(Request $request){

        $data = [
            'name'=>$request->input('name'),
            'email'=>$request->input('email'),
            'subject'=>$request->input('subject'),
            'message'=>$request->input('message')


        ];



     Mail::to('aqoitteam@gmail.com')->send(new ContactMail($data) );
      return redirect()->back();


    }

    public function search(Request $request){

        $keyword = $request->keyword;
       $result =  SearchModel::where('description','LIKE','%'.$keyword.'%')->get();
        return view('search',['results'=>$result]);
    }

}
